// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000
// Procedures for viewing a packed file.
//......................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	LPCTSTR				lpszStopSign;
extern	LPCTSTR				lpszNullString;
extern	LPCTSTR				lpszPacked;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	TCHAR				szFileName[MAX_PATH];
extern	HANDLE				hInputFile;
extern	PACKED_FILE_ID_HDR	pfidhdr;
extern	PACKED_FILE_HEADER	pfhdr;
extern	LPPACKED_FILE_DIR	lppfd;
extern	BYTE				PackedFileId[4];
extern	BYTE				PackedFileId1[4];
extern	BYTE				PackedFileIdZ[4];
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HWND				hEditListWindow;
extern	BOOL				bEditWindowDisplayed;
extern	HWND				hEditWindow;
extern	NUMBERFMT			nFormatInfo;
extern	int					iMaxItems;
extern	int					iItemsSelected;
extern	int					iItemCount;
extern	BOOL				bExtract;
extern	BOOL				bWeHaveLzw;
extern	DWORD				dwTip;
extern	DWORD				dwTipString;
extern	DWORD				dwTipHelp;
extern	CONFIG				cfg;

// Variables used by this procedure.
//..................................
HANDLE				hPackedEvent;
HANDLE				hPackedOpen;
LPCTSTR				lpszTscPacked = "TSCPACKED";
DWORD				dwHeaderSize = sizeof(PACKED_FILE_DIR);
ULARGE_INTEGER		uliCompSize;
BOOL				bViewPackedFiles;
LPPACKED_FILE_DIR	lppfdScratch;
TCHAR				szExtract[] = "Select Files to Extract";
TCHAR				szDelete[] = "Select Files to Delete";
BOOL				bViewOnly;

// View the contents of a packed file.
//....................................
VOID ViewAPackedFile()
{
	OPENFILENAME				ofn;
	BOOL						bResult;
	DWORD						dwBytesRead;
	DWORD						dwOldHelpTopic;
	RECT						rect;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_VIEW);
	bViewOnly = TRUE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = sizeof(szFileName);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a Packed File to View");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szFileName,sizeof(szFileName));

		// Select the packed file to add files to.
		//........................................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto ViewEnd;
		}
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);

		// Make sure the file is a valid packed file.
		//...........................................
		lpFileName = PathFindFileName((LPCTSTR)&szFileName);
		lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);

		hInputFile = CreateMyFile((LPTSTR)&szFileName,GENERIC_READ,0,NULL,OPEN_EXISTING,
								  FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hInputFile)
		{
			goto ViewEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfidhdr,
							 sizeof(PACKED_FILE_ID_HDR),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ViewEnd;
		}
		bResult = SearchFor((LPBYTE)&PackedFileId,lstrlen(PackedFileId),
						   (LPBYTE)&pfidhdr,4);

		// If we did not have a match, search for the alternate id.
		//.........................................................
		if (!bResult)
		{
			bResult = SearchFor((LPBYTE)&PackedFileId1,
								lstrlen(PackedFileId1),(LPBYTE)&pfidhdr,4);
		}
		if (bResult)
		{
			bWeHaveLzw = TRUE;
			break;
		}
		if (!bResult)
		{
			bResult = SearchFor((LPBYTE)&PackedFileIdZ,lstrlen(PackedFileIdZ),
							   (LPBYTE)&pfidhdr,4);
		}
		if (bResult)
		{
			bWeHaveLzw = FALSE;
			break;
		}
		// We do not have a valid packed file.
		//....................................
		SetLastError(IDS_INVALIDPACKEDFILE);
		ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
	
		// Close the file and try again.
		//..............................
		bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		if (!bResult)
		{
			goto ViewEnd;
		}
		hInputFile = 0;
	}
	EmptyTheMessageQue();

	// Get the size of the packed file.
	//.................................
	uliCompSize.QuadPart = GetMyFileSize((LPTSTR)&szFileName,hInputFile);
	if (uliCompSize.QuadPart == -1)
	{
		goto ViewEnd;
	}
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto ViewEnd;
	}
	// Create the central directory for the packed file.
	//..................................................
	bResult = BuildPackedFileCentralDir((LPBYTE)&szFileName,hInputFile);
	if (!bResult)
	{
		goto ViewEnd;
	}
	// Create our event for viewing the contents of a packed file.
	//............................................................
	hPackedEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("PackedEvent"));
	if (!hPackedEvent)
	{
		ErrorProcedure((LPTSTR)lpszNA,IDS_CREATEEVENT,MB_OK);
		goto ViewEnd;
	}
	// Create the window to display the packed file contents in.
	// Use hEditWindow and bEditWindowDisplayed
	//..........................................................
	GetClientRect(hMainWindow,&rect);

	hEditWindow = CreateWindowEx(0,lpszTscPacked,lpszNullString,
								 WS_CAPTION | WS_CHILD | WS_SYSMENU | 
								 WS_VISIBLE | WS_CLIPCHILDREN,
								 rect.left,rect.top+37,
								 rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);

	if (!hEditWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto ViewEnd;
	}
	// Open the event object.
	//.......................
	hPackedOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("PackedEvent"));
	if (!hPackedOpen)
	{
		DestroyWindow(hEditWindow);
		goto ViewEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hPackedEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	ViewEnd:

	Crc32Table(DELETE_TABLE);

	if (hPackedOpen)
	{
		CloseHandle(hPackedOpen);
		hPackedOpen = 0;
	}
	if (hPackedEvent)
	{
		CloseHandle(hPackedEvent);
		hPackedEvent = 0;
	}
	if (lppfd)
	{
		DeallocateMemory(lppfd);
		lppfd = 0;
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Register the window class for viewing the contents of a
// packed file.
//........................................................
BOOL RegisterPackedWindow()
{
	WNDCLASS	wc;

	wc.style		 = 0;
	wc.lpfnWndProc	 = (WNDPROC)PackedWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpszPacked);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszTscPacked;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for viewing the contents of a packed file.
//............................................................
LRESULT CALLBACK PackedWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int			iResult;

	switch(uMsg)
	{
		case WM_CREATE:
		{
			HMENU			hTscWinMenu;
			MENUITEMINFO	mii;
			ULARGE_INTEGER	uliScratch;
			TCHAR			szBuffer[300];
			TCHAR			szFormatedNumber[64];

			// Disable the move menu item on the window menu.
			//...............................................
			hTscWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hTscWinMenu,SC_MOVE,FALSE,&mii);

			// Set the title for the window. Use the title of
			// the tsc encrypted file. Add the compressed
			// percentage figure after the title.
			//...............................................
			if (bViewPackedFiles)
			{
				if (uliCompSize.QuadPart < pfidhdr.uliTotalSizeOfFiles.QuadPart)
				{
					uliScratch.QuadPart = (100 - ((uliCompSize.QuadPart * 100) /
										   pfidhdr.uliTotalSizeOfFiles.QuadPart));
				}
				else
				{
					uliScratch.QuadPart = 0;
				}
				_ui64toa(uliScratch.QuadPart,(LPBYTE)&szBuffer,10);
				GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szBuffer,
								&nFormatInfo,(LPTSTR)&szFormatedNumber,
								sizeof(szFormatedNumber));

				StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%s - %s%%"),
							    lpFileName,&szFormatedNumber);

				SetWindowText(hWnd,(LPCTSTR)&szBuffer);
			}
			else
			{
				// Setup the correct title for deleting or extracting.
				//....................................................
				if (bExtract)
				{
					StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%s - %s"),
								    lpFileName,&szExtract);
				}
				else
				{
					StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%s - %s"),
									lpFileName,&szDelete);
				}
				SetWindowText(hWnd,(LPCTSTR)&szBuffer);

				// Set the focus on the first item in the list.
				//.............................................
				lppfdScratch->STATE = LVIS_FOCUSED;
			}
			// Setup the virtual list view window.
			//....................................
			hEditListWindow = CreatePackedListView(hWnd);
			if (!hEditListWindow)
			{
				return(-1);
			}
			SetFocus(hEditListWindow);
			bEditWindowDisplayed = TRUE;
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			ListView_SetBkColor(hEditListWindow,GetSysColor(COLOR_WINDOW));			
		}
		break;

		case WM_SIZE:
		{
			// Resize the virtual list view window.
			//.....................................
			ResizePackedListView(GetDlgItem(hWnd,IDC_TSCLISTVIEW),hWnd);
		}
		break;

		case WM_NOTIFY:
		{
			return(EditPackedViewNotify(hWnd,(LPNMHDR)lParam));
		}

		case WM_USER:
		{
			SetFocus(hEditListWindow);
		}
		break;

		case WM_TIP:
		{
			dwTipHelp = ChangeHelpTopic(IDH_VLSELECTION);

			iResult = DialogBox(hInst,TEXT("TSCGTIP"),hEditListWindow,(DLGPROC)TscgTipProc);

			EmptyTheMessageQue();

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			}
			ChangeHelpTopic(dwTipHelp);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			// Notify the view procedure that it can continue
			// and exit.
			//...............................................
			SetEvent(hPackedEvent);
			bEditWindowDisplayed = FALSE;
		}
		break;

        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
	return(0L);
}

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of a packed file.
//..............................................................
LRESULT EditPackedViewNotify(HWND hWnd, LPNMHDR lpNmhdr)
{
	LPNMLVDISPINFO		lpLvdi;
	int					iIndex;
	int					iFirstIndex;
	int					iLastIndex;
	int					iFirstMark;
	int					iLastMark;
	int					iFocus;
	int					iFocused;
	BOOL				bContinuous;
	LPPACKED_FILE_DIR	lppDir;
	LPNMLISTVIEW		lpnmListView;
	BOOL				bCtrlKey;
	BOOL				bAltKey;
	BOOL				bShiftKey;
	int					i;
	int					iLastItem;
	int					iSelectedItems;
	LPPACKED_FILE_DIR	lpLastItem;
	SHORT				sTemp;

	bCtrlKey = FALSE;
	bAltKey = FALSE;
	bShiftKey = FALSE;

	// Determine the keys pressed during the selection.
	//.................................................
	sTemp = GetKeyState(VK_CONTROL);
	if (sTemp & 0x8000)
	{
		bCtrlKey = TRUE;
	}
	sTemp = GetKeyState(VK_SHIFT);
	if (sTemp & 0x8000)
	{
		bShiftKey = TRUE;
	}
	sTemp = GetKeyState(VK_MENU);
	if (sTemp & 0x8000)
	{
		bAltKey = TRUE;
	}
	
	switch (lpNmhdr->code)
	{
		case LVN_GETDISPINFO:
		{
			DWORD				dwScratch;
			ULARGE_INTEGER		uliSize;
			ULARGE_INTEGER		uliCompressed;
			ULARGE_INTEGER		uliScratch;
			LPBYTE				lpBuffer;
			TCHAR				szBuffer[MAX_PATH];
			TCHAR				szFormatedNumber[64];
			FILETIME			ftScratch;
			FILETIME			ftLocalTime;
			SYSTEMTIME			stLocalTime;
			TCHAR				szLocalDate[128];
			TCHAR				szLocalTime[64];

			lpLvdi = (LPNMLVDISPINFO)lpNmhdr;

			// Determine the index of the item we need and get it from
			// the central directory for the packed file.
			//........................................................
			iIndex = lpLvdi->item.iItem;
			lppDir = lppfd;
			dwScratch = iIndex * dwHeaderSize;
			__asm
			{
				mov		eax,dwScratch
				add		lppDir,eax
			}
			// Fill in the items state if we are deleting or extracting.
			//..........................................................
			if (lpLvdi->item.mask & LVIF_STATE)
			{
				if (!bViewPackedFiles)
				{
					lpLvdi->item.state = lppDir->STATE;
				}
			}
			// Fill in the text for the item and subitems.
			//............................................
			if (lpLvdi->item.mask & LVIF_TEXT)
			{
				switch(lpLvdi->item.iSubItem)
				{
					case 0:
					{
						// Get the file name.
						//...................
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)lppDir->FileName);
					}
					break;

					case 1:
					{
						// Get the number of bits or level.
						//.................................
						dwScratch = lppDir->pfh.LargestBitCode;
						StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%u"),
									    dwScratch);
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 2:
					{
						// Get the uncompressed size of the file.
						//.......................................
						_ui64toa(lppDir->pfh.uliFileSize.QuadPart,(LPBYTE)&szBuffer,10);
						GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szBuffer,&nFormatInfo,
									   (LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szFormatedNumber);
					}
					break;

					case 3:
					{
						// Get the compressed size of the file.
						//.......................................
						_ui64toa(lppDir->pfh.uliCompressedFileSize.QuadPart,
							    (LPBYTE)&szBuffer,10);
						GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szBuffer,&nFormatInfo,
									   (LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szFormatedNumber);
					}
					break;

					case 4:
					{
						// Calculate the compression percentage.
						//......................................
						uliSize.QuadPart = lppDir->pfh.uliFileSize.QuadPart;
						uliCompressed.QuadPart = lppDir->pfh.uliCompressedFileSize.QuadPart;
						uliScratch.QuadPart  = (100 - ((uliCompressed.QuadPart * 100) / 
												uliSize.QuadPart));
						_ui64toa(uliScratch.QuadPart,(LPBYTE)&szBuffer,10);
						GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szBuffer,&nFormatInfo,
									   (LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szFormatedNumber);
					}
					break;

					case 5:
					{
						// Do the date.
						//.............
						ftScratch = lppDir->pfh.ftLastWrite;
						FileTimeToLocalFileTime((LPFILETIME)&ftScratch,
										        (LPFILETIME)&ftLocalTime);
						FileTimeToSystemTime((LPFILETIME)&ftLocalTime,
											 (LPSYSTEMTIME)&stLocalTime);
						// Format the date.
						//.................
						GetDateFormat(LOCALE_USER_DEFAULT,0,&stLocalTime,
									  TEXT("ddd',' dd MMM yyyy"),(LPTSTR)&szLocalDate,
									  sizeof(szLocalDate));
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szLocalDate);
					}
					break;

					case 6:
					{
						// Do the time.
						//.............
						ftScratch = lppDir->pfh.ftLastWrite;
						FileTimeToLocalFileTime((LPFILETIME)&ftScratch,
											    (LPFILETIME)&ftLocalTime);
						FileTimeToSystemTime((LPFILETIME)&ftLocalTime,
											 (LPSYSTEMTIME)&stLocalTime);
						// Format the time.
						//.................
						GetTimeFormat(LOCALE_USER_DEFAULT,0,&stLocalTime,
									  TEXT("HH:mm:ss tt"),(LPTSTR)&szLocalTime,
									  sizeof(szLocalTime));
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szLocalTime);
					}
					break;

					case 7:
					{
						// Do the attributes.
						//...................
						ZeroMemory(&szBuffer,sizeof(szBuffer));
						lpBuffer = szBuffer;
						dwScratch = lppDir->pfh.dwFileAttributes;
						if (dwScratch & FILE_ATTRIBUTE_ARCHIVE)
						{
							*lpBuffer++ = 0x61;
						}
						if (dwScratch & FILE_ATTRIBUTE_COMPRESSED)
						{
							*lpBuffer++ = 0x63;
						}
						if (dwScratch & FILE_ATTRIBUTE_ENCRYPTED)
						{
							*lpBuffer++ = 0x65;
						}
						if (dwScratch & FILE_ATTRIBUTE_HIDDEN)
						{
							*lpBuffer++ = 0x68;
						}
						if (dwScratch & FILE_ATTRIBUTE_READONLY)
						{
							*lpBuffer++ = 0x72;
						}
						if (dwScratch & FILE_ATTRIBUTE_SYSTEM)
						{
							*lpBuffer++ = 0x73;
						}
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 8:
					{
						// Do the header CRC.
						//...................
						dwScratch = lppDir->pfh.dwHeaderCrc32;
						StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%08X"),
										dwScratch);
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 9:
					{
						// Do the file CRC.
						//.................
						dwScratch = lppDir->pfh.dwFileCrc32;
						StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%08X"),
										dwScratch);
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					default:
						break;
				}
			}
		}
		break;

		// If we are just viewing the packed file we return. 
		//..................................................
		case NM_CLICK:
		{
			// If we are just viewing the file get out of here.
			//.................................................
			if (bViewPackedFiles)
			{
				break;
			}
			lpnmListView = (LPNMLISTVIEW)lpNmhdr;

			// Determine the index of the item.
			//.................................
			iIndex = lpnmListView->iItem;

			// Check to see if we have a click on an invalid area.
			//....................................................
			if (iIndex == -1)
			{
				// Unmark all the items and set the first selectable item
				// as focused.
				//.......................................................
				for (i = 0; i < iItemCount; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwHeaderSize
						mul		ecx
						add		eax,lppfdScratch
						mov		lppDir,eax
					}
					// Only unmark an item if it is marked.
					//.....................................
					if (lppDir->STATE)
					{
						lppDir->STATE = 0;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					}
				}
				// Set the focus on the first item that can be selected.
				//......................................................
				lppfdScratch->STATE = LVIS_FOCUSED;
				i = 0;
			
				// Update the entry.
				//..................
				SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
				iItemsSelected = 0;
			}
			// Handle the unmark all procedure. 
			//.................................
			else if (bCtrlKey && bAltKey)
			{
				if (iItemsSelected)
				{
					for (i = 0; i < iItemCount; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwHeaderSize
							mul		ecx
							add		eax,lppfdScratch
							mov		lppDir,eax
						}
						// Only unmark an item if it is marked.
						//.....................................
						if (lppDir->STATE)
						{
							lppDir->STATE = 0;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
						}
					}
					iItemsSelected = 0;

					// Set the focus on the first item that can be selected.
					//......................................................
					lppfdScratch->STATE = LVIS_FOCUSED;
					i = 0;
			
					// Update the entry.
					//..................
					SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
				}
			}
			// Handle the mark all procedure.
			//...............................
			else if (bAltKey)
			{
				// If the maximum numer of items is already
				// selected, return.
				//.........................................
				if (iItemsSelected == iMaxItems)
				{
					return(0);
				}
				iSelectedItems = 0;

				for (i = 0; i < iItemCount; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwHeaderSize
						mul		ecx
						add		eax,lppfdScratch
						mov		lppDir,eax
					}
					// Set the last item variables.
					//.............................
					iLastItem = i;
					iSelectedItems++;
					lpLastItem = lppDir;

					// Only mark an item if it is not marked.
					//.......................................
					if (!lppDir->STATE)
					{
						lppDir->STATE = LVIS_SELECTED;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					}
					// If we have one with the focus set, unset it.
					//.............................................
					if (lppDir->STATE & LVIS_FOCUSED)
					{
						lppDir->STATE = LVIS_SELECTED;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					}
				}
				// Set the focus on the last item.
				//................................
				lpLastItem->STATE = (LVIS_SELECTED | LVIS_FOCUSED);
				SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iLastItem,0);
				iItemsSelected = iSelectedItems;
			}
			// Handle the mark a range of keys procedure.
			//...........................................
			else if (bShiftKey)
			{
				// If no items selected just mark the item.
				//.........................................
				if (iItemsSelected == 0)
				{
					// Find the item with the focus and remove it.
					//............................................
					lppDir = lppfdScratch;
					i = 0;

					while(TRUE)
					{
						if (lppDir->STATE)
						{
							lppDir->STATE = 0;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
							break;
						}
						__asm
						{
							mov		eax,dwHeaderSize
							add		lppDir,eax
						}
						i++;
					}
					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwHeaderSize
						mul		ecx
						add		eax,lppfdScratch
						mov		lppDir,eax
					}
					lppDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
					SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
					iItemsSelected++;
				}
				else
				{
					// More than one item selected.
					//.............................
					iFirstIndex = -1;
					iFocused = -1;
					bContinuous = FALSE;

					for (i = 0; i < iItemCount; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwHeaderSize
							mul		ecx
							add		eax,lppfdScratch
							mov		lppDir,eax
						}
						if (lppDir->STATE & LVIS_SELECTED)
						{
							if (iFirstIndex == -1)
							{
								iFirstIndex = i;
							}
							iLastIndex = i;
						}
						if (lppDir->STATE & LVIS_FOCUSED)
						{
							iFocused = i;
						}
					}
					// See if we have a continuous block.
					//...................................
					iSelectedItems = (iLastIndex - iFirstIndex) + 1;
					if (iSelectedItems == iItemsSelected)
					{
						bContinuous = TRUE;
					}
					// Setup a default range.
					//.......................
					iFirstMark = iFirstIndex;
					iLastMark = iLastIndex;
					iFocus = iFocused;

					if (bContinuous)
					{
						// Determine how to mark the items.
						//.................................
						if (iFocused == iLastIndex && iIndex > iLastIndex)
						{
							iLastMark = iIndex;
							iFocus = iIndex;
						}
						else if (iFocused == iFirstIndex && iIndex < iFirstIndex)
						{
							iFirstMark = iIndex;
							iFocus = iIndex;
						}
						else if (iFocused == iLastIndex && iIndex < iFirstIndex)
						{
							iFirstMark = iIndex;
							iFocus = iIndex;
							iLastMark = iFirstIndex;
						}
						else if (iFocused == iFirstIndex && iIndex > iLastIndex)
						{
							iFirstMark = iLastIndex;
							iLastMark = iIndex;
							iFocus = iIndex;
						}
						else if (iIndex < iFocused && iIndex >= iFirstIndex)
						{
							iLastMark = iIndex;
							iFocus = iIndex;
						}
						else if (iIndex > iFocused && iIndex <= iLastIndex)
						{
							iFirstMark = iIndex;
							iFocus = iIndex;
						}
					}
					else
					{
						// We do not have a continuous band of marked items.
						// We mark from the focus to the selected item.
						//..................................................
						if (iIndex < iFocused)
						{
							iFirstMark = iIndex;
							iFocus = iIndex;
							iLastMark = iFocused;
						}
						else if (iIndex > iFocused)
						{
							iLastMark = iIndex;
							iFocus = iIndex;
							iFirstMark = iFocused;
						}
						else
						{
							iFirstMark = iIndex;
							iLastMark = iIndex;
							iFocus = iIndex;
						}
					}
					// Display the marked items if there has been a change.
					//.....................................................
					if (iFirstMark != iFirstIndex || iLastMark != iLastIndex || iFocus != iFocused)
					{
						// First remove the focus.
						//........................
						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwHeaderSize
								mul		ecx
								add		eax,lppfdScratch
								mov		lppDir,eax
							}
							if (lppDir->STATE & LVIS_FOCUSED)
							{
								lppDir->STATE ^= LVIS_FOCUSED;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
								break;
							}
						}
						// Now mark the items.
						//....................
						iItemsSelected = 0;

						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwHeaderSize
								mul		ecx
								add		eax,lppfdScratch
								mov		lppDir,eax
							}
							// If the item is outside the range and marked,
							// unmark it.
							//.............................................
							if ((i < iFirstMark || i > iLastMark) && lppDir->STATE)
							{
								lppDir->STATE = 0;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
							}
							else if ((i >= iFirstMark && i <= iLastMark) && lppDir->STATE == 0)
							{
								lppDir->STATE = LVIS_SELECTED;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
							}
						}
						// Set the focus.
						//...............
						__asm
						{
							mov		eax,iFocus
							mov		ecx,dwHeaderSize
							mul		ecx
							add		eax,lppfdScratch
							mov		lppDir,eax
						}
						lppDir->STATE |= LVIS_FOCUSED;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iFocus,0);

						// Set the number of items selected.
						//..................................
						iItemsSelected = (iLastMark - iFirstMark) + 1;
					}
				}
			}
			// Handle the mark one item at a time procedure.
			// If the control key is pressed mark the key if
			// it is not already selected and change focus.
			//..............................................
			else if (bCtrlKey)
			{
				// If no items selected just mark the item.
				//.........................................
				if (iItemsSelected == 0)
				{
					// Find the item with the focus and remove it.
					//............................................
					lppDir = lppfdScratch;
					i = 0;

					while(TRUE)
					{
						if (lppDir->STATE)
						{
							lppDir->STATE = 0;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
							break;
						}
						__asm
						{
							mov		eax,dwHeaderSize
							add		lppDir,eax
						}
						i++;
					}
					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwHeaderSize
						mul		ecx
						add		eax,lppfdScratch
						mov		lppDir,eax
					}
					lppDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
					SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
					iItemsSelected++;
				}
				else
				{
					// Get the selected item.
					//.......................
					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwHeaderSize
						mul		ecx
						add		eax,lppfdScratch
						mov		lppDir,eax
					}
					if (lppDir->STATE == 0)
					{
						// We have a valid item to mark. Find the 
						// one with the focus and just change it 
						// to selected.
						//.......................................
						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwHeaderSize
								mul		ecx
								add		eax,lppfdScratch
								mov		lpLastItem,eax
							}
							if (lpLastItem->STATE & LVIS_FOCUSED)
							{
								lpLastItem->STATE = LVIS_SELECTED;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
								break;
							}
						}
						// Now mark the newly selected item.
						//..................................
						lppDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
						iItemsSelected++;
					}
					else if (lppDir->STATE & LVIS_SELECTED)
					{
						// We have a selected item. Unselect it.
						//......................................
						lppDir->STATE = 0;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
						iItemsSelected--;

						// If there are no items now selected, set the focus on
						// first item.
						//.....................................................
						if (iItemsSelected == 0)
						{
							lppfdScratch->STATE = LVIS_FOCUSED;
							i = 0;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
						}
						else
						{
							// We have one or more selected. Set the focus
							// on the last item, or if we have one with the
							// focus already set, leave it along.
							//.............................................
							for (i = 0; i < iItemCount; i++)
							{
								__asm
								{
									mov		eax,i
									mov		ecx,dwHeaderSize
									mul		ecx
									add		eax,lppfdScratch
									mov		lppDir,eax
								}
								if (lppDir->STATE)
								{
									iLastItem = i;
									lpLastItem = lppDir;
									if (lpLastItem->STATE & LVIS_FOCUSED)
									{
										break;
									}
								}
							}
							// Set the focus on the appropriate item.
							//.......................................
							lpLastItem->STATE = (LVIS_SELECTED | LVIS_FOCUSED);
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iLastItem,0);
						}
					}
				}
			}
			else
			{
				// Normal individual selection. One selection kills
				// all the others.
				__asm
				{
					mov		eax,iIndex
					mov		ecx,dwHeaderSize
					mul		ecx
					add		eax,lppfdScratch
					mov		lppDir,eax
				}
				// We have items selected. Unmark all of them.
				//............................................
				for (i = 0; i < iItemCount; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwHeaderSize
						mul		ecx
						add		eax,lppfdScratch
						mov		lpLastItem,eax
					}
					if (lpLastItem->STATE)
					{
						lpLastItem->STATE = 0;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					}
				}
				// Mark the item.
				//...............
				lppDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
				SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
				iItemsSelected = 1;
			}
		}
		break;

		case LVN_KEYDOWN:
		{
			LPNMLVKEYDOWN		lpKdn;

			lpKdn = (LPNMLVKEYDOWN)lpNmhdr;

			if (lpKdn->wVKey == VK_ESCAPE)
			{
				iItemsSelected = 0;
				SendMessage(hWnd,WM_CLOSE,0,0);
			}
		}
		break;

		// These two messages are not currently used by the program.
		//..........................................................
		case LVN_ODCACHEHINT:
        case LVN_ODFINDITEM:
			break;

		default:
			break;
	}
	return(0);
}

// Create the virtual list view window for viwing our packed file.
//................................................................
HWND CreatePackedListView(HWND hWndParent)
{
	DWORD       dwStyle;
	HWND        hWndListView;
	LVCOLUMN	lvColumn;
	int			i;

	int			iColumnSize[10] = {150,55,100,100,45,160,120,100,100,100};

	TCHAR		szColumns[10][12] = {TEXT("File"),
									 TEXT("Bits"),
									 TEXT("Size"),
									 TEXT("Compressed"),
									 TEXT("%"),
									 TEXT("Date"),
									 TEXT("Time"),
									 TEXT("Attributes"),
									 TEXT("Header CRC"),
									 TEXT("File CRC")};
	if (!bWeHaveLzw)
	{
		StringCbCopy((LPTSTR)&szColumns[1][0],sizeof(szColumns[1]),TEXT("Level"));
	}

	dwStyle =   WS_TABSTOP | 
				WS_CHILD | 
				WS_BORDER | 
				WS_VISIBLE |
				LVS_NOSORTHEADER |
				LVS_REPORT | 
				LVS_OWNERDATA;
	  
	hWndListView = CreateWindowEx(WS_EX_CLIENTEDGE,WC_LISTVIEW,NULL,
                                  dwStyle,0,0,0,0,hWndParent,
                                  (HMENU)IDC_TSCLISTVIEW,hInst,NULL);

	if(!hWndListView)
	{
		return(0);
	}
	// Set the extended styles for the virtual list box.
	//..................................................
	if (bViewOnly)
	{
		ListView_SetExtendedListViewStyleEx(hWndListView,0,LVS_EX_GRIDLINES);
	}
	else
	{
		ListView_SetExtendedListViewStyleEx(hWndListView,0,LVS_EX_GRIDLINES |
											LVS_EX_FULLROWSELECT |
											LVS_EX_ONECLICKACTIVATE |
											LVS_EX_UNDERLINEHOT);
	}
	SendMessage(hWndListView,WM_SETFONT,
			   (WPARAM)GetStockObject(ANSI_FIXED_FONT),FALSE);

	// Resize the window to fit in the parent windows.
	//................................................
	ResizeEditListView(hWndListView, hWndParent);

	// Set the header columns for the virtual list view window.
	//.........................................................
	lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	for(i = 0; i < 10; i++)
	{
		if (i == 0)
		{
			lvColumn.fmt = LVCFMT_LEFT;
		}
		else if (i == 2 || i == 3)
		{
			lvColumn.fmt = LVCFMT_RIGHT;
		}
		else
		{
			lvColumn.fmt = LVCFMT_CENTER;
		}
		lvColumn.pszText = szColumns[i];
		lvColumn.cx = iColumnSize[i];
		SendMessage(hWndListView,LVM_INSERTCOLUMN,(WPARAM)i, 
			       (LPARAM)&lvColumn);
	}
	// Empty the list.
	//................
	SendMessage(hWndListView,LVM_DELETEALLITEMS,0,0);

	// Set the number of items in the list.
	//.....................................
	SendMessage(hWndListView,LVM_SETITEMCOUNT,(WPARAM)pfidhdr.iFilesInVault, 
		       (LPARAM)LVSICF_NOINVALIDATEALL);

	// Set the callback mask so we can control the state information.
	//...............................................................
	SendMessage(hWndListView,LVM_SETCALLBACKMASK,(WPARAM)LVIS_SELECTED | LVIS_FOCUSED,0);

	return(hWndListView);
}

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizePackedListView(HWND hWndListView, HWND hWndParent)
{
	RECT  rc;

	GetClientRect(hWndParent, &rc);

	MoveWindow(hWndListView, rc.left,rc.top,rc.right - rc.left,rc.bottom - rc.top,TRUE);
}
